#include <amxmodx>
#include <amxmisc>

#define VERSION	"1"
#define OFFSET	64

static Array:g_a_Aliases;
static g_a_Reason[33][64],g_a_RandCmd[33][64];
static g_i_AliasNum[33],g_i_Warnings[33];
static g_p_MessType,g_p_BanType;

public plugin_init() {
	register_plugin("Aliases checker",VERSION,"creator_52");
	get_aliases();
	g_p_MessType=register_cvar("ac_mess_type","1");
	g_p_BanType=register_cvar("ac_ban_type","kick <userid>  <reason> detected!");
}

public get_aliases() {
	new s_File[128];
	get_configsdir(s_File,127);
	format(s_File,127,"%s/aliases.ini",s_File);
	if(!file_exists(s_File)) {
		server_print("[Aliases checker] File 'aliases.ini' not found!");
		return PLUGIN_CONTINUE;
	}
	else {
		g_a_Aliases=ArrayCreate(64);
		new i_File=fopen(s_File,"rt");
		new s_Buffer[64];
		while(!feof(i_File)) {
			fgets(i_File,s_Buffer,63);
			trim(s_Buffer);
			if(!s_Buffer[0] || s_Buffer[0]==';' || (s_Buffer[0]=='/' && s_Buffer[1]=='/')) {
				continue;
			}
			ArrayPushString(g_a_Aliases,s_Buffer);
		}
		fclose(i_File);
		new i_Size=ArraySize(g_a_Aliases);
		if(!i_Size) {
			server_print("[Aliases checker] No aliases loaded!");
			return PLUGIN_CONTINUE;
		}
		else {
			server_print("[Aliases checker] Loaded %d aliases.",i_Size);
		}
	}
	return PLUGIN_CONTINUE;
}

public form_rand_string(i_Player) {
	for(new a;a<15;a++) {
		g_a_RandCmd[i_Player][a]=random_num('a','z');
	}
}

public client_disconnect(i_Player) {
	if(task_exists(i_Player)) {
		remove_task(i_Player);
	}
	if(task_exists(i_Player+OFFSET)) {
		remove_task(i_Player+OFFSET);
	}
}

public client_putinserver(i_Player) {
	if(is_user_bot(i_Player) || is_user_hltv(i_Player)) {
		return PLUGIN_CONTINUE;
	}
	else {
		g_i_AliasNum[i_Player]=0;
		g_i_Warnings[i_Player]=0;
		set_task(5.0,"start_check_aliases",i_Player);
	}
	return PLUGIN_CONTINUE;
}

public start_check_aliases(i_Player) {
	form_rand_string(i_Player);
	check_aliases(i_Player+OFFSET);
	set_task(3.0,"check_aliases",i_Player+OFFSET,_,_,"a",4);
	set_task(15.0,"final_check",i_Player+OFFSET);
}

public check_aliases(i_Player) {
	i_Player-=OFFSET;
	if(g_i_AliasNum[i_Player]>=ArraySize(g_a_Aliases)-1) {
		g_i_AliasNum[i_Player]=0;
	}
	new s_Buffer[64];
	ArrayGetString(g_a_Aliases,g_i_AliasNum[i_Player],s_Buffer,63);
	new i_StrLen=strlen(s_Buffer);
	if(s_Buffer[0]=='[' && s_Buffer[i_StrLen-1]==']') {
		format(g_a_Reason[i_Player],i_StrLen-2,s_Buffer[1]);
		g_i_AliasNum[i_Player]++;
		ArrayGetString(g_a_Aliases,g_i_AliasNum[i_Player],s_Buffer,63);
	}
	client_cmd(i_Player,g_a_RandCmd[i_Player]);
	client_cmd(i_Player,s_Buffer);
	return PLUGIN_CONTINUE;
}

public final_check(i_Player) {
	i_Player-=OFFSET;
	if(g_i_Warnings[i_Player]>=3) {
		new s_Punishment[128],s_UserId[8],s_Ip[32],s_Name[64],s_SteamId[64];
		num_to_str(get_user_userid(i_Player),s_UserId,7);
		format(s_UserId,7,"#%s",s_UserId);
		get_user_info(i_Player,"name",s_Name,63);
		get_user_ip(i_Player,s_Ip,31,0);
		get_user_authid(i_Player,s_SteamId,63);
		get_pcvar_string(g_p_BanType,s_Punishment,127);
		replace_all(s_Punishment,127,"<userid>",s_UserId);
		replace_all(s_Punishment,127,"<name>",s_Name);
		replace_all(s_Punishment,127,"<ip>",s_Ip);
		replace_all(s_Punishment,127,"<steamid>",s_SteamId);
		replace_all(s_Punishment,127,"<reason>",g_a_Reason[i_Player]);
		server_cmd(s_Punishment);
		switch(get_pcvar_num(g_p_MessType)) {
			case 1:client_print(0,print_chat,"Violation by %s: %s detected!",s_Name,g_a_Reason[i_Player]);
			case 2:show_hudmessage(0,"Violation by %s: %s detected!",s_Name,g_a_Reason[i_Player]);
		}
	}
	else {
		g_i_Warnings[i_Player]=0;
		set_task(20.0,"start_check_aliases",i_Player);
	}
}

public client_command(i_Player) {
	if(!is_user_connected(i_Player) || is_user_bot(i_Player) || is_user_hltv(i_Player)) {
		return PLUGIN_CONTINUE;
	}
	else {
		new s_Arg[64],s_CurAlias[64];
		ArrayGetString(g_a_Aliases,g_i_AliasNum[i_Player],s_CurAlias,63);
		read_argv(0,s_Arg,63);
		if(equal(s_CurAlias,s_Arg)) {
			if(task_exists(i_Player+OFFSET)) {
				remove_task(i_Player+OFFSET);
			}
			g_i_AliasNum[i_Player]++;
			g_i_Warnings[i_Player]=0;
			start_check_aliases(i_Player);
		}
		else if(equal(g_a_RandCmd[i_Player],s_Arg)) {
			g_i_Warnings[i_Player]++;
		}
		else {
			return PLUGIN_CONTINUE;
		}
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}